/*
   This program shows how a Java program can redirect
   its standard output stream (stdout) to a file.

   After this program redirects stdout, it just
   reads lines from stdin and echos them to stdout.

   If standard input (stdin) is the console keyboard,
   use ^z (Control-z) to denote the end of file
   (and you must use ^z at the beginning of a line!).

   Be sure to try, and think about, what happens when
   you execute the following cmd.exe command line. Notice
   that in this command line, cmd.exe does an I/O redirection.

   C:\> java RedirectStdoutToFile >test2.txt


   Important: Notice how this program is similar to the
   following command line.

   C:\> java Echo > test.txt

   In the case of the above command line, the shell
   program (cmd.exe) sets up the I/O redirection before
   running the program Echo.class. In the case of this
   program, the program itself does its own I/O redirection.
*/
import java.util.Scanner;
import java.io.*;

public class RedirectStdoutToFile
{
   public static void main(String[] args) throws FileNotFoundException
   {
      // Set System.out to be a file (instead of whatever stdout originally was).
      System.setOut( new PrintStream( new FileOutputStream( "test.txt" ) ) );

      // Create a Scanner object to make it easier to use System.in
      Scanner scanner = new Scanner( System.in );

      // Echo every line of input from stdin to stdout.
      while ( scanner.hasNextLine() )
      {
         String oneLine = scanner.nextLine();
         // If you want to, you could manipulate (i.e., filter)
         // the line of input before sending it to stdout.
         System.out.println( oneLine );
      }
   }
}